/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)SignatureInitListener.java	1.1 04/11/05
 */

package com.sun.ts.tests.jsf.spec.webapp.tldsig;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * A <code>ServletContextListener</code> implementation that will
 * store the <code>ServletContext</code> within the
 * <code>ServletContextHolder</code> class.
 *
 * @see ServletContextHolder
 */
public class SignatureInitListener implements ServletContextListener {


    // ------------------------------------- Methods from ServletContextListener

    public void contextInitialized(ServletContextEvent servletContextEvent) {

        System.out.println("SignatureInitListener: contextInitialized");
        ServletContextHolder.
            setServletContext(servletContextEvent.getServletContext());
    } // END contextInitialized


    public void contextDestroyed(ServletContextEvent servletContextEvent) {

        System.out.println("SignatureInitListener: contextDestroyed");
        ServletContextHolder.setServletContext(null);

    } // END contextDestoryed

}
