/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TCKApplicationFactory.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.spec.webapp.factoryfinder;

import javax.faces.application.ApplicationFactory;
import javax.faces.application.Application;
import javax.faces.context.FacesContextFactory;

/**
 * <p>A simple wrapper class for FactoryFinder validation.</p>
 */
public class TCKApplicationFactory extends ApplicationFactory {

    /**
     * <p>The @{link ApplicationFactory} instance provided by
     * the JSF implementation under test.</p>
     */
    private ApplicationFactory factory;


    /**
     * Default constructor.
     */
    public TCKApplicationFactory() {

        System.out.println("[TCKApplicationFactory] Default CTOR");

    }

    /**
     * <p>Constructs a new TCKApplicationFactory instance that wraps
     * the default {@link ApplicationFactory} instance of the implementation
     * under test.</p>
     * @param factory the {@link ApplicationFactory} of the implementation under
     *  test
     */
    public TCKApplicationFactory(ApplicationFactory factory) {

        System.out.println("[TCKApplicationFactory] Factory CTOR");
        this.factory = factory;

    } // END TCKApplicationFactory


    // ----------------- Methods from javax.faces.application.ApplicationFactory


    /**
     * <p>Create (if needed) and return an {@link javax.faces.application.Application}
     * instance for this web application.</p>
     */
    public Application getApplication() {

        return factory.getApplication();

    } // END getApplication


    /**
     * <p>Replace the {@link javax.faces.application.Application} instance that
     * will be returned for this web application.</p>
     *
     * @param application The replacement {@link javax.faces.application.Application}
     * instance
     *
     * @throws NullPointerException if <code>application</code> is
     * <code>null</code>.
     */
    public void setApplication(Application application) {

        factory.setApplication(application);

    } // END setApplication


    // ---------------------------------------------------------- Public Methods


    /**
     * <p>Returns the wrapped ApplicationFactory instance passed to the
     * constructor by the JSF implementation under test.</p>
     */
    public ApplicationFactory getWrappedInstance() {

        return factory;

    } // END getWrappedInstance

    /**
     * <p>Returns the 'this' ApplicationFactory instance for testing purposes
     * 	  only..</p>
     */
	public ApplicationFactory getWrapped() {
		return this;
	}
}
