/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Flow_b_Bean.java 70314 2013-02-26 19:48:11Z dougd $
 */

package com.sun.ts.tests.jsf.spec.flows.basicmethodcall.beans;

import javax.faces.flow.FlowScoped;
import java.io.Serializable;

import javax.faces.context.FacesContext;
import javax.inject.Named;

@Named
@FlowScoped(value ="flow-b")
public class Flow_b_Bean implements Serializable {

   public String getName() {
       return "Flow_B_Bean";
   }
   
   public String getReturnValue() {
       return "/return1";
   }
   
   public String methodWithOutcome(String strParam, Integer intParam) {
       if (!strParam.equals("param1Value")) {
           throw new IllegalArgumentException();
       }
       if (!intParam.equals(getInteger())) {
           throw new IllegalArgumentException();
       }
       
       return "next_b";
   }
   
   public void voidMethod() {
       FacesContext context = FacesContext.getCurrentInstance();
       context.getExternalContext().getRequestMap().put("message", "voidMethod called in flow-b");
       
   }
   
   public Integer getInteger() {
       return Integer.valueOf(Integer.MAX_VALUE);
   }
}
