/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SessionScopedPrivateBean.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.spec.el.managedbean.common;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.io.Serializable;

public class SessionScopedPrivateBean extends ScopedBean implements Serializable {

    private @PostConstruct void onPostConstruct() {
	setPostConstructProperty("session private PostConstruct method invoked");
    }

    private @PreDestroy void onPreDestroy() {
	PreDestroyProp.setPreDestroyProperty("session private PreDestroy method invoked");
    }

    public SessionScopedPrivateBean() {
        System.out.println("SessionScopedPrivateBean created.");
    }
}
