/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ApplicationScopedProtectedBean.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.spec.el.managedbean.common;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.io.Serializable;

public class ApplicationScopedProtectedBean extends ScopedBean implements Serializable {

    protected @PostConstruct void onPostConstruct() {
	setPostConstructProperty("application protected PostConstruct method invoked");
    }

    protected @PreDestroy void onPreDestroy() {
	PreDestroyProp.setPreDestroyProperty("application protected PreDestroy method invoked");
    }

    public ApplicationScopedProtectedBean() {
        System.out.println("ApplicationScopedProtectedBean created.");
    }
}
