/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64539 2012-01-09 17:09:27Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.postconstructcustomscopeevent;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

import javax.faces.application.Application;
import javax.faces.event.PostConstructCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.event.common.BaseSystemEventTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends BaseSystemEventTestServlet {
    private static final String SCOPE_NAME = "tckScope";
    private HashMap<String, Object> tckScope = new HashMap<String, Object>();
    
    {
	tckScope.put("csContext", "scope");
    }

     private ScopeContext tck_scope_context = new ScopeContext(SCOPE_NAME, tckScope);

    @Override
    protected SystemEvent createEvent(Object src) {
	return new PostConstructCustomScopeEvent(tck_scope_context);
    }

    // ------------------------------------------- PostKeepFlashValueEvent

    public void postConstructCustomScopeEventGetContextTest(
	    HttpServletRequest request, HttpServletResponse response)
	    throws ServletException, IOException {
	PrintWriter pw = response.getWriter();
	Application app = getFacesContext().getApplication();

	if (app != null) {
	    PostConstructCustomScopeEvent pScope = 
		    (PostConstructCustomScopeEvent) createEvent(app);
	    String result = pScope.getContext().getScopeName();

	    if (!SCOPE_NAME.equals(result)) {
		pw.println(JSFTestUtil.FAIL + " Wrong name for ScopeContext!"
			+ JSFTestUtil.NL + "Expected: " + SCOPE_NAME
			+ JSFTestUtil.NL + "Received: " + result);
		
	    } else {
		pw.println(JSFTestUtil.PASS);
		
	    }

	} else {
	    pw.println(JSFTestUtil.FAIL + " Unexpected problem obtaining "
		    + "Application instance.");
	}
    }

} // TestServlet