/*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64521 2012-01-06 20:14:52Z dougd $
 */


package com.sun.ts.tests.jsf.api.javax_faces.event.postconstructapplicationevent;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.application.Application;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.event.common.BaseSystemEventTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends BaseSystemEventTestServlet {

    @Override
    protected SystemEvent createEvent(Object src) {
	Application app = getFacesContext().getApplication();
	
	return  new PostConstructApplicationEvent(app);
    }


    //---------------------------------------------- PostConstructApplicationEvent Tests
    
    public void postConstructApplicationEventCtorTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter pw = response.getWriter();
	Application app = getFacesContext().getApplication();

	if (app != null) {
	    PostConstructApplicationEvent pca = (PostConstructApplicationEvent) createEvent(app);
	    if (pca == null) {
		pw.println(JSFTestUtil.FAIL + " Unable to create PostConstructApplicationEvent");
	    } else {
		pw.println(JSFTestUtil.PASS);
	    }
	} else {
	    pw.println(JSFTestUtil.FAIL +" Unexpected problem obtaining "
		    + "Application instance.");
	}
    }

    public void postConstructApplicationEventGetAppTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter pw = response.getWriter();
	Application app = getFacesContext().getApplication();
	PostConstructApplicationEvent pca = (PostConstructApplicationEvent) createEvent(app);

	if (app != null) {
	    if (app != pca.getApplication()) {
		pw.println(JSFTestUtil.FAIL
			+ "PostConstructApplicationEvent.getApplication() "
			+ "returned unexpected result.");
	    } else {
		pw.println(JSFTestUtil.PASS);
	    }

	} else {
	    pw.println("Test FAILED. Unexpected problem obtaining "
		    + "Application instance.");
	}
    }
}
