/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class UndeployAll
extends Task {
    private static final String NL = System.getProperty("line.separator", "\n");
    private static final String PASSWORD_FILE_NAME = "password.txt";
    private File j2eehome;
    private File j2eehomebin;
    private File tshome;
    private File tshomebin;
    private String[] env;
    private String asadmin;
    private Process proc;
    private StreamWatcher errThread;
    private StreamWatcher outThread;
    private List procs = new ArrayList();
    private List threads = new ArrayList();
    private Properties processorProps = new Properties();
    private String username = "admin";
    private String password = "adminadmin";
    private File passwordfile;
    private boolean remoteinstance;
    private String adminport = "4849";
    private String instancename = "server-1";
    private String hostname = "localhost";
    private boolean is9x;

    public void setTshome(File tshome) {
        this.tshome = tshome;
    }

    public void setRemoteinstance(boolean value) {
        this.remoteinstance = value;
    }

    public void setAdminport(String adminport) {
        this.adminport = adminport;
    }

    public void setInstancename(String instancename) {
        this.instancename = instancename;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordfile(File passwordfile) {
        this.passwordfile = passwordfile;
    }

    public void setJ2eehome(File j2eehome) {
        this.j2eehome = j2eehome;
    }

    public void execute() throws BuildException {
        this.checkPreConditions();
        this.setProps();
        this.log("J2EE_HOME       : \"" + this.j2eehome + "\"", 3);
        this.log("TS_HOME         : \"" + this.tshome + "\"", 3);
        try {
            this.adjustFor9x();
            this.undeployComponents(this.listComponents());
        }
        catch (Exception ex) {
            System.err.println(ex);
            throw new BuildException((Throwable)ex);
        }
    }

    private void adjustFor9x() throws BuildException {
        try {
            StringBuffer buf = this.runAsadmin("version");
            this.is9x = buf.indexOf("8.") == -1 && buf.indexOf("7.") == -1 && buf.indexOf("Reference Implementation 1.4") == -1;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (this.is9x && this.passwordfile == null) {
            this.passwordfile = new File(this.tshomebin, PASSWORD_FILE_NAME);
        }
        if (this.is9x && !this.passwordfile.isFile()) {
            throw new BuildException("The passwordfile, \"" + this.passwordfile + "\", does not exist, specify a valid password " + "file using the passwordfile attribute");
        }
        this.log("Running against SJSAS 9.x is " + this.is9x, 2);
    }

    private void setProps() {
        this.j2eehomebin = new File(this.j2eehome, "bin");
        this.asadmin = this.j2eehomebin.getPath() + File.separator + "asadmin";
        this.tshomebin = new File(this.tshome, "bin");
    }

    private void checkPreConditions() throws BuildException {
        if (this.tshome == null || this.j2eehome == null) {
            throw new BuildException("Must specify the attributes: tshome and j2eehome.");
        }
        if (!this.tshome.isDirectory()) {
            throw new BuildException("The specified tshome attribute, \"" + this.tshome + "\", does not exist");
        }
        if (!this.j2eehome.isDirectory()) {
            throw new BuildException("The specified j2eehome attribute, \"" + this.j2eehome + "\", does not exist");
        }
    }

    private String getPasswordArgs() {
        String result = null;
        result = this.is9x ? " --passwordfile " + this.passwordfile.getPath() : " --password " + this.password;
        return result;
    }

    private String[] listComponents() throws Exception {
        ArrayList<String> appnames = new ArrayList<String>();
        String args = this.remoteinstance ? "--user " + this.username + this.getPasswordArgs() + " --host " + this.hostname + " --port " + this.adminport + " " + this.instancename : "--user " + this.username + this.getPasswordArgs();
        this.runAsadmin("list-components " + args);
        StringTokenizer outtokn = new StringTokenizer(this.outThread.getBuffer().toString(), "\n");
        if (this.errThread.getBuffer().length() > 0) {
            System.err.println("ERROR: " + this.errThread.getBuffer().toString());
        }
        while (outtokn.hasMoreTokens()) {
            String line = outtokn.nextToken();
            if (line.trim().matches("Command list-components executed successfully.") || line.trim().matches("Nothing to list.") || line.trim().startsWith("WARNING:")) continue;
            String delimiters = " \t";
            StringTokenizer apptokn = new StringTokenizer(line, delimiters);
            String app = apptokn.nextToken();
            appnames.add(app);
            this.log("LIST COMPONENT        : \"" + app + "\"", 3);
        }
        return appnames.toArray(new String[appnames.size()]);
    }

    private void undeployComponents(String[] appnames) throws Exception {
        int total;
        int n = total = appnames == null ? 0 : appnames.length;
        if (total == 0) {
            this.log("No Applications To Undeploy", 2);
        } else {
            for (int i = 0; i < total; ++i) {
                String component = appnames[i];
                this.log("UNDEPLOY COMPONENT        : \"" + component + "\"", 3);
                String args = this.remoteinstance ? "--user " + this.username + this.getPasswordArgs() + " --cascade=true" + " --host " + this.hostname + " --port " + this.adminport + " --target " + this.instancename : "--user " + this.username + this.getPasswordArgs() + " --cascade=true";
                this.runAsadmin("undeploy " + args + " " + component);
            }
        }
    }

    private StringBuffer runAsadmin(String cmd) throws Exception {
        return this.runCommand(this.asadmin + " " + cmd, this.j2eehomebin, true);
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "").toUpperCase().startsWith("WIN");
    }

    private StringBuffer runCommand(String cmd, File dir, boolean blocking) throws Exception {
        StringBuffer buf = new StringBuffer();
        int pstat = 0;
        long THREAD_TIMEOUT = 600000L;
        try {
            Runtime rt = Runtime.getRuntime();
            if (this.isWindows()) {
                cmd = "cmd /c " + cmd;
            }
            this.log("Running ==> \"" + cmd + "\"", 2);
            this.proc = rt.exec(cmd, this.env, dir);
            this.errThread = new StreamWatcher(this.proc.getErrorStream(), this.project, "ERR");
            this.errThread.start();
            this.outThread = new StreamWatcher(this.proc.getInputStream(), this.project, "OUT");
            this.outThread.start();
            if (blocking) {
                pstat = this.proc.waitFor();
                this.errThread.join(600000L);
                this.outThread.join(600000L);
                buf = this.outThread.getBuffer();
            } else {
                this.procs.add(this.proc);
                this.threads.add(this.errThread);
                this.threads.add(this.outThread);
            }
            this.log("Proc status ==> \"" + pstat + "\"", 2);
        }
        catch (Exception ex) {
            this.log(ex.toString(), 0);
            throw ex;
        }
        return buf;
    }

    public static class StreamWatcher
    extends Thread {
        private final String NL;
        private StringBuffer buf = new StringBuffer();
        private InputStream in;
        private String id;
        private Project project;

        public StreamWatcher(InputStream in, Project project, String id) {
            this.in = in;
            this.project = project;
            this.id = id;
            this.NL = System.getProperty("line.separator", "\n");
        }

        public StringBuffer getBuffer() {
            return this.buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.project.log("Starting StreamWatcher for " + this.in, 3);
            BufferedReader breader = null;
            try {
                breader = new BufferedReader(new InputStreamReader(this.in));
                String line = breader.readLine();
                while (line != null) {
                    this.buf.append(line + this.NL);
                    line = breader.readLine();
                    Thread.sleep(2L);
                }
                int index = this.buf.lastIndexOf(this.NL);
                if (index != -1) {
                    this.buf = this.buf.delete(index, this.buf.length());
                }
            }
            catch (InterruptedException e) {
                this.project.log("Stream Watcher for \"" + this.id + "\" Stopping", 2);
            }
            catch (InterruptedIOException e) {
                this.project.log("Stream Watcher for \"" + this.id + "\" Stopping", 2);
            }
            catch (Exception e) {
                this.project.log("StreamWatcher error is " + e, 0);
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (Exception e) {
                    this.project.log("StreamWatcher error closing input stream, exception is: " + e, 0);
                }
            }
        }
    }
}

