/*
 * Copyright (c) 2007, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SigTestData.java 75653 2018-05-18 10:26:33Z pabhat $
 */

package com.sun.ts.tests.signaturetest;

import java.util.Properties;

/**
 * This class holds the data passed to a signature test invocation during
 * the setup phase.  This allows us to keep the passed data separate and
 * reuse the data between the signature test framework base classes.
 */
public class SigTestData {

    private Properties props;

    public SigTestData(Properties props) {
        this.props = props;
    }

    public String getVehicle() {
        return props.getProperty("vehicle", "");
    }

    public String getBinDir() {
        return props.getProperty("bin.dir", "");
    }

    public String getTSHome() {
        return props.getProperty("ts_home", "");
    }
    
    public String getTestClasspath() {
        return props.getProperty("sigTestClasspath", "");
    }
 
    public String getJavaeeLevel() {
    	return props.getProperty("javaee.level", "");
    }
    
    public String getCurrentKeywords() {
    	return props.getProperty("current.keywords", "");
    }
    
    public String getProperty(String prop) {
        return props.getProperty(prop);
    }

    public String getOptionalTechPackagesToIgnore() {
        return props.getProperty("optional.tech.packages.to.ignore", "");
    }

    public String getJtaJarClasspath() {
        return props.getProperty("jtaJarClasspath", "");
    }
} // end class SigTestData
