/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
package com.sun.ts.tests.jpa.jpa22.repeatable.convert;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class NumberToStateConverter implements AttributeConverter<Integer, String> {

    public String convertToDatabaseColumn(Integer attribute) {
        System.out.println("*** Entering NumberToStateConverter:convertToDatabaseColumn["+attribute+"] ***");
        String value = "NumberToStateConverter:convertToDatabaseColumn";

        if (attribute.equals(1)) {
            value = "MA";
        } else if (attribute.equals(2)) {
            value = "CA";
        } else if (attribute.equals(-1)) {
            throw new RuntimeException("Exception was thrown from convertToDatabaseColumn");
        } else {
            value = attribute.toString();
        }
        System.out.println("*** Leaving NumberToStateConverter:convertToDatabaseColumn["+value+"] ***");

        return value;
    }

    public Integer convertToEntityAttribute(String dbData) {
        System.out.println("*** Entering NumberToStateConverter:convertToEntityAttribute["+dbData+"] ***");
        int value = 0;
        if (dbData.equals("MA")) {
            value = 1;
        } else if (dbData.equals("CA")) {
            value = 2;
        } else if (dbData.equals("-2")) {
            throw new RuntimeException("Exception was thrown from convertToEntityAttribute");
        } else {
            value=Integer.valueOf(dbData);
        }

        System.out.println("*** Entering NumberToStateConverter:convertToEntityAttribute["+value+"] ***");       return value;
    }

}

