/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
/*
 * $Id: Insurance.java 75116 2017-06-29 15:53:24Z jsupol $
 */

package com.sun.ts.tests.jpa.jpa22.query.stream;

import javax.persistence.*;
import java.util.Collection;

/*
 * Insurance
 */

@Entity
@Table(name="INSURANCE")
public class Insurance implements java.io.Serializable {

	private static final long serialVersionUID = 22L;
	// Instance variables
    private int  id;
    private String  carrier;
    private Collection<Employee> employees = new java.util.ArrayList<Employee>();

    public Insurance() {
    }

    public Insurance(int id, String carrier) {
        this.id = id;
        this.carrier = carrier;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="INSID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="CARRIER")
    public String getCarrier() {
        return carrier;
    }
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(cascade=CascadeType.ALL, mappedBy="insurance")
    public Collection<Employee> getEmployees() {
        return employees;
    }
    public void setEmployees(Collection<Employee> employees) {
        this.employees = employees;
    }
        @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Insurance)) return false;

        Insurance o1 = (Insurance) o;

        boolean result = false;

        if (this.getId() == o1.getId() && this.getCarrier().equals(o1.getCarrier()) ) {
            result = true;
        }

        return result;

    }
    @Override
    public int hashCode() {
         return this.getId() + this.getCarrier().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getId());
        result.append(", carrier: " + getCarrier());
        result.append("]");
        return result.toString();
    }
}
