package com.sun.ts.tests.jpa.core.override.mapkey;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Entity
public class TheatreLocation implements Serializable {

    @Id
    private Long id;
    @Column(unique = true, nullable = false)
    private String code;
    @ManyToMany()
    private Set<TheatreCompany> companies = new HashSet();

    public TheatreLocation() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int hash = 0;
        hash += (this.getId() != null ? this.getId().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof TheatreLocation)) {
            return false;
        }
        TheatreLocation other = (TheatreLocation) object;
        if (this.getId() != other.getId() && (this.getId() == null ||
                !this.getId().equals(other.getId()))) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "com.sun.ts.tests.jpa.core.override.mapkey." +
                "TheatreLocation[id=" + getId() + "]";
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Set<TheatreCompany> getCompanies() {
        return companies;
    }

    public void setCompanies(Set<TheatreCompany> companies) {
        this.companies = companies;
    }

    public void addCompany(TheatreCompany company) {
        this.companies.add(company);
    }
}
