/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.identifiabletype;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Version;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */

@Entity
@IdClass(DID2EmployeeId.class)
public class DID2Employee implements Serializable {

    private static final long serialVersionUID = 1L;
    
    @Id String firstName;
    @Id String lastName;
    @Version
    Integer empNo;

    public DID2Employee() {
    }

    public DID2Employee(DID2EmployeeId eId) {
        this(eId.getFirstName(), eId.getLastName());
    }

    public DID2Employee(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public int getEmpNo() {
        return empNo;
    }

    public void setEmpNo(int empNo) {
        this.empNo = empNo;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}
