/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.core.lock.query;

import javax.persistence.*;
import java.util.Collection;

/*
 * Insurance
 */

@Entity
@Table(name="INSURANCE")
public class Insurance implements java.io.Serializable {

    // Instance variables
    private int  id;
    private String  carrier;
    private Collection<Employee> employees = new java.util.ArrayList<Employee>();

    public Insurance() {
    }

    public Insurance(int id, String carrier) {
        this.id = id;
        this.carrier = carrier;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="INSID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="CARRIER")
    public String getCarrier() {
        return carrier;
    }
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(cascade=CascadeType.ALL, mappedBy="insurance")
    public Collection<Employee> getEmployees() {
        return employees;
    }
    public void setEmployees(Collection<Employee> employees) {
        this.employees = employees;
    }


    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getId());
        result.append(", first: " + getCarrier());
        result.append("]");
        return result.toString();
    }
}
