/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
/*
 * $Id: Employee.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.inheritance.nonentity;

import javax.persistence.*;

/*
 * Employee
 */

@Entity
@Table(name="EMPLOYEE")
@Inheritance
@DiscriminatorColumn(name = "STATUS")
public abstract class Employee extends Personnel {

    protected int	     id;
    protected String	     firstName;
    protected String	     lastName;

    /** the project this Employee leads */
    protected Project project;

    /** the department this Employee belongs to */
    protected Department department;

   // ===========================================================
   // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @ManyToOne
    @JoinColumn(name="FK_DEPT")
    public Department getDepartment() {
        return department;
    }
    public void setDepartment(Department department) {
        this.department = department;
    }

    @OneToOne
    @JoinColumn(name="FK_PROJECT")
    public Project getProject() {
        return project;
    }
    public void setProject(Project project) {
        this.project = project;
    }
}

