 /*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

 /*
  * $Id: Coffee.java 65615 2012-03-29 19:02:39Z sdimilla $
  */

package com.sun.ts.tests.jpa.core.exceptions;

 import javax.persistence.Column;
 import javax.persistence.Entity;
 import javax.persistence.Id;
 import javax.persistence.Table;

@Entity
@Table(name = "COFFEE")
public class Coffee implements java.io.Serializable {

    private Integer id;
    private String brandName;
    private float price;
    
    public Coffee() {
    }
    
    public Coffee(Integer id, String brandName, float price) {
	this.id = id;
	this.brandName = brandName;
        this.price = price;
    }
    
    @Id
    @Column(name="ID")
    public Integer getId() {
        return id;
    }
    public void setId(Integer id) {
        this.id = id;
    }
    
    @Column(name="BRANDNAME")
    public String getBrandName() {
        return brandName;
    }
    public void setBrandName(String bName) {
        this.brandName = bName;
    }
    
    @Column(name="PRICE")
    public float getPrice() {
        return price;
    }
    public void setPrice(float price) {
        this.price = price;
    }


    public String toString() {
        return "Coffee id=" + getId() + ", brandName=" + getBrandName() + ", price=" + getPrice();
    }

    @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Coffee)) return false;

        Coffee c = (Coffee) o;

        boolean result = false;

        if (this.getId() == c.getId() && this.getBrandName().equals(c.getBrandName()) && this.getPrice()==c.getPrice()) {
            result = true;
        }

        return result;

    }

    @Override
    public int hashCode() {
        return this.getId() + this.getBrandName().hashCode() + new Float(this.getPrice()).hashCode();
    }

}
