/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


/*
 * $Id: Order.java 68602 2012-11-19 16:30:19Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.methodoverride;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusImpl;
import com.sun.ts.tests.jpa.core.callback.common.GenerictListenerImpl;

import javax.persistence.*;
import java.util.Collection;

@Entity
@Table(name="ORDER_TABLE")
public class Order extends CallbackStatusImpl
        implements java.io.Serializable, CallbackStatusIF {
    private String id;
    private double totalPrice;
    private LineItem sampleLineItem;
    private Collection<LineItem> lineItemsCollection = new java.util.ArrayList<LineItem>();
    private GenerictListenerImpl callbackImpl = new GenerictListenerImpl();
    
    public Order() {
        super();
    }
    
    public Order(String id, double totalPrice) {
        this.id = id;
        this.totalPrice = totalPrice;
    }
    
    @Transient
    public GenerictListenerImpl getCallbackImpl() {
        return callbackImpl;
    }
    public void setCallbackImpl(GenerictListenerImpl callbackImpl) {
        this.callbackImpl = callbackImpl;
    }

    /////////////////////////////////////////////////////////////////////////
    //@PrePersist
    private void prePersist() {
        getCallbackImpl().prePersist(this);
    }

    //@PostPersist
    private void postPersist() {
        getCallbackImpl().postPersist(this);
    }
    
    
    //@PreRemove
    private void preRemove() {
       getCallbackImpl().preRemove(this);
    }
    //@PostRemove
    private void postRemove() {
        getCallbackImpl().postRemove(this);
    }
    
    
    //@PreUpdate
    private void preUpdate() {
        getCallbackImpl().preUpdate(this);
    }
    //@PostUpdate
    private void postUpdate() {
        getCallbackImpl().postUpdate(this);
    }
    
    //@PostLoad
    private void postLoad() {
        getCallbackImpl().postLoad(this);
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    @Id
    @Column(name="ID")
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    
    @Column(name="TOTALPRICE")
    public double getTotalPrice() {
        return totalPrice;
    }
    public void setTotalPrice(double price) {
        this.totalPrice = price;
    }
    
    // 1x1
    @OneToOne(cascade = CascadeType.REMOVE)
    @JoinColumn(
        name="FK0_FOR_LINEITEM_TABLE")
    public LineItem getSampleLineItem() {
        return sampleLineItem;
    }
    public void setSampleLineItem(LineItem l) {
        this.sampleLineItem = l;
    }

    @OneToMany(mappedBy="order", cascade = CascadeType.ALL)
    public Collection<LineItem> getLineItemsCollection() {
        return lineItemsCollection;
    }
    public void setLineItemsCollection(Collection<LineItem> c) {
        this.lineItemsCollection = c;
    }
    
    public void addLineItem(LineItem p) {
        getLineItemsCollection().add(p);
    }
}
