/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated;

import java.io.Serializable;

import javax.persistence.Embeddable;

@Embeddable
public class EmbeddedEmployee implements Serializable {

	private static final long serialVersionUID = 22L;
	public String employeeName;
	public int employeeId;

	public EmbeddedEmployee() {
		// for JPA
	}

	public EmbeddedEmployee(Employee4 employee) {
		this.employeeName = employee.getLastName();
		this.employeeId = employee.getId();
	}
}
