/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "DATATYPES")
public class PropertyIntId implements java.io.Serializable {

    // ===========================================================
    // instance variables

    protected int id;

    private int intData;


    // ===========================================================
    // constructors
    public PropertyIntId() {
    }

    public PropertyIntId(int id, int intData) {

        this.id = id;
        this.intData = intData;

    }

    @Id
    @Column(name = "ID")
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name = "INTDATA")
    public int getIntData() {
        return intData;
    }

    public void setIntData(int intData) {
        this.intData = intData;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         result.append(", int: " + getIntData());
         result.append("]");
         return result.toString();
     }
}
