/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.common.schema30;

import javax.persistence.*;
import java.util.Collection;

/*
 * Address
 */

@Entity
@Table(name = "ADDRESS")
public class Address implements java.io.Serializable {


    // Instance Variables
    private String id;
    private String street;
    private String city;
    private String state;
    private String zip;
    private Collection<Phone> phones = new java.util.ArrayList<Phone>();

    public Address() {
    }

    public Address(String id, String street, String city, String state, String zip) {
        this.id = id;
        this.street = street;
        this.city = city;
        this.state = state;
        this.zip = zip;
    }

    public Address(String id, String street, String city, String state, String zip,
                   Collection<Phone> phones) {
        this.id = id;
        this.street = street;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.phones = phones;
    }

    // ===========================================================
    // getters and setters for the persistent fields

    @Id
    @Column(name = "ID")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name = "STREET")
    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Column(name = "CITY")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name = "STATE")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name = "ZIP")
    public String getZip() {
        return zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    // ===========================================================
    // getters and setters for association fields

    // 1xMANY
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "address")
    public Collection<Phone> getPhones() {
        return phones;
    }

    public void setPhones(Collection<Phone> phones) {
        this.phones = phones;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", street: " + getStreet());
        result.append(", city: " + getCity());
        result.append(", state: " + getState());
        result.append(", zip: " + getZip());
        result.append("]");
        return result.toString();
    }
}
