/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyExceptionListener.java 69201 2012-12-18 17:34:13Z af70133 $
 */
package com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests;

import com.sun.ts.lib.util.TestUtil;
import javax.jms.JMSException;
import javax.jms.ExceptionListener;

public class MyExceptionListener implements ExceptionListener {

    private String name = null;
    private JMSException exception = null;
    boolean complete = false;

    public MyExceptionListener() { this("MyExceptionListener"); }
    public MyExceptionListener(String name) { this.name = name; }

    // getters/setters
    public String getName() { return name; }
    public void setName(String name) { this.name = name; }
    public JMSException getException() { return exception; }
    public void setException(JMSException exception) { this.exception = exception; }
    public boolean isComplete() { return complete; }
    public void setComplete(boolean complete) { this.complete = complete; }

    public void onException(JMSException exception) {
	TestUtil.logMsg("Got JMSException: " + exception);
	this.exception = exception;
	complete = true;
    }

}
