/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyCompletionListener2.java 70441 2013-03-05 16:41:18Z af70133 $
 */
package com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests;

import com.sun.ts.lib.util.TestUtil;
import javax.jms.*;
import java.util.ArrayList;

public class MyCompletionListener2 implements CompletionListener {

    private String name = null;
    private Message message = null;
    private Exception exception = null;
    private int numMessages = 1;
    boolean complete = false;

    public MyCompletionListener2() { this("MyCompletionListener2"); }
    public MyCompletionListener2(String name) { this.name = name; }

    // getters/setters
    public String getName() { return name; }
    public void setName(String name) { this.name = name; }
    public Message getMessage() { return message; }
    public void setMessage(Message message) { this.message = message; }
    public Exception getException() { return exception; }
    public void setException(Exception exception) { this.exception = exception; }
    public boolean isComplete() { return complete; }
    public void setComplete(boolean complete) { this.complete = complete; }

    public void onCompletion(Message message) {
	TestUtil.logMsg("onCompletion(): Got Message: " + message);
	this.message = message;
	complete = true;
    }

    public void onException(Message message, Exception exception) {
	TestUtil.logMsg("OnException(): Got Exception: " + exception);
	TestUtil.logMsg("With Message: " + message);
	this.exception = exception;
	this.message = message;
	complete = true;
    }

}
