/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Checklist;
import com.sun.interview.Interview;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.help.HelpSet;
import javax.help.Map;

public abstract class Question {
    protected Interview interview;
    protected String tag;
    private String baseTag;
    protected final String key;
    private String text;
    private String summary;
    private Map.ID id;
    private URL image;

    protected Question(Interview interview, String baseTag) {
        if (baseTag == null || baseTag.length() == 0) {
            throw new IllegalArgumentException("No tag specified");
        }
        this.interview = interview;
        this.baseTag = baseTag;
        this.updateTag();
        interview.add(this);
        String c = interview.getClass().getName();
        int dot = c.lastIndexOf(".");
        if (dot != -1) {
            c = c.substring(dot + 1);
        }
        c = c.replace('$', '.');
        this.key = c + "." + baseTag;
    }

    protected Question(Interview interview) {
        this.interview = interview;
        this.baseTag = null;
        this.tag = null;
        this.key = null;
    }

    public Interview getInterview() {
        return this.interview;
    }

    public String getKey() {
        return this.key;
    }

    public String getTag() {
        return this.tag;
    }

    String getBaseTag() {
        return this.baseTag;
    }

    void updateTag() {
        this.tag = this.interview.getTag() == null ? this.baseTag : this.interview.getTag() + "." + this.baseTag;
    }

    protected void setText(String text) {
        this.text = text.trim();
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.getResourceString(this.interview, this.key + ".text", true);
            if (this.text == null) {
                this.text = this.key + ".text";
            }
        }
        return MessageFormat.format(this.text, this.getTextArgs());
    }

    protected Object[] getTextArgs() {
        return null;
    }

    protected void setSummary(String summary) {
        this.summary = summary.trim();
    }

    public String getSummary() {
        if (this.summary == null) {
            this.summary = this.getResourceString(this.interview, this.key + ".smry", true);
            if (this.summary == null) {
                this.summary = this.key + ".smry";
            }
        }
        return this.summary;
    }

    public void setImage(String resource) {
        this.image = Question.class.getResource(resource);
    }

    protected void setImage(URL u) {
        this.image = u;
    }

    public URL getImage() {
        if (this.image == null) {
            this.image = this.getClass().getResource(this.tag + ".gif");
        }
        if (this.image == null) {
            this.image = this.interview.getDefaultImage();
        }
        return this.image;
    }

    public Map.ID getHelpID() {
        if (this.id == null) {
            this.id = this.getID(this.interview, this.key);
        }
        return this.id;
    }

    private Map.ID getID(Interview i, String key) {
        javax.help.Map m;
        Map.ID id = null;
        if (i.getParent() != null) {
            id = this.getID(i.getParent(), key);
        }
        if (id != null) {
            return id;
        }
        HelpSet hs = i.getHelpSet();
        if (hs != null && (m = hs.getLocalMap()) != null && m.isValidID(key, hs)) {
            id = Map.ID.create(key, hs);
            return id;
        }
        return null;
    }

    public Checklist.Item[] getChecklistItems() {
        return null;
    }

    public void addMarker(String name) {
        this.interview.addMarker(this, name);
    }

    public void removeMarker(String name) {
        this.interview.removeMarker(this, name);
    }

    public boolean hasMarker(String name) {
        return this.interview.hasMarker(this, name);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isEnabled() {
        return !this.isHidden();
    }

    protected abstract Question getNext();

    public abstract void clear();

    public abstract String getStringValue();

    public abstract void setValue(String var1) throws Interview.Fault;

    public abstract boolean isValueValid();

    public abstract boolean isValueAlwaysValid();

    protected abstract void load(Map var1);

    protected abstract void save(Map var1);

    protected void export(Map data) {
    }

    public void reload() {
        HashMap map = new HashMap();
        this.save(map);
        this.clear();
        this.load(map);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Question)) {
            return false;
        }
        Question oq = (Question)other;
        return Question.equal(this.tag, oq.tag) && Question.equal(this.getStringValue(), oq.getStringValue());
    }

    private static boolean equal(String s1, String s2) {
        return s1 == null || s2 == null ? s1 == s2 : s1.equals(s2);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.tag ? 0 : this.tag.hashCode());
        String str_val = this.getStringValue();
        hash = 31 * hash + (null == str_val ? 0 : str_val.hashCode());
        return hash;
    }

    protected String getResourceString(String key) {
        return this.interview.getResourceString(key);
    }

    protected String getResourceString(String key, boolean checkAncestorsFirst) {
        return this.interview.getResourceString(key, checkAncestorsFirst);
    }

    private String getResourceString(Interview interview, String key, boolean checkAncestorsFirst) {
        return interview.getResourceString(key, checkAncestorsFirst);
    }
}

