/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jaxws/wsi/w2j/rpc/literal/R2751/W2JRLR2751Client.java $ $LastChangedDate: 2011-04-21 07:51:41 -0700 (Thu, 21 Apr 2011) $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2751;

import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.lib.harness.EETest;

public class W2JRLR2751Client extends SOAPClient{

    public W2JRLR2751Client(String webServerHost, int port, int mode) throws EETest.Fault{
        this(webServerHost, port, mode, null);
    }

    public W2JRLR2751Client(String webServerHost, int port, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://w2jrlr2751testservice.org/W2JRLR2751TestService.wsdl");
        stubContext.setService("W2JRLR2751TestService");
        stubContext.setPort("W2JRLR2751TestPort");
        stubContext.setEndpointInterface(W2JRLR2751Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr2751.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr2751.wsdlloc.1";
    }

    public String echoIt(String item, com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2751.ConfigHeader ch, 
                         com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2751.ConfigHeader2 ch2,
                         com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2751.ConfigHeader3 ch3) 
                         throws Exception {
        return ((W2JRLR2751Test)stubContext.getStub()).echoIt(item, ch, ch2, ch3);
    }

}
