/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SwaTestImpl2.java 62602 2011-04-21 14:51:41Z kgrucci $
 */


package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest;

import javax.xml.ws.WebServiceException;
import javax.xml.soap.*;
import javax.activation.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.*;
import java.net.*;
import java.awt.*;
import javax.jws.WebService;

@WebService(
    portName="SwaTestTwoPort",
    serviceName="WSIDLSwaTestService",
    targetNamespace="http://SwaTestService.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/WSW2JDLSwaTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.SwaTest2"
)

public class SwaTestImpl2 implements SwaTest2 {
    public com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.OutputResponseString putMultipleAttachments(com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.InputRequestPut request, javax.activation.DataHandler attach1, javax.activation.DataHandler attach2)  {
	try {
	    OutputResponseString theResponse = new OutputResponseString();
 	    theResponse.setMyString("ok");
	    System.out.println("Enter putMultipleAttachments() ......");
	    if(attach1 == null) {
		System.err.println("attach1 is null (unexpected)");
		theResponse.setMyString("not ok");
	    }
	    if(attach2 == null) {
		System.err.println("attach2 is null (unexpected)");
		theResponse.setMyString("not ok");
	    }
	    System.out.println("Leave putMultipleAttachments() ......");
	    return theResponse;
	} catch (Exception e) {
	    throw new WebServiceException(e.getMessage());
	}
    }

    public com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.OutputResponseString echoNoAttachments(com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.InputRequestString request)  {
	try {
	    System.out.println("Enter echoNoAttachments() ......");
	    OutputResponseString theResponse = new OutputResponseString();
 	    theResponse.setMyString(request.getMyString());
	    System.out.println("Leave echoNoAttachments() ......");
	    return theResponse;
	} catch (Exception e) {
	    throw new WebServiceException(e.getMessage());
	}
    }
}
