/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Hello2Impl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.dlhelloproviderservice;

import javax.xml.ws.*;
import javax.xml.soap.*;

import java.util.Iterator;

import com.sun.ts.tests.jaxws.common.JAXWS_Util;

/*
 * Provider<SOAPMessage> - req/res a SOAPMessage in Message Mode
 */
@WebServiceProvider(
	serviceName="HelloService",
	portName="Hello2Port",
	targetNamespace="http://helloservice.org/wsdl",
	wsdlLocation="WEB-INF/wsdl/WSDLHelloProviderService.wsdl"
)
@BindingType(value=javax.xml.ws.soap.SOAPBinding.SOAP11HTTP_BINDING)
@ServiceMode (value=javax.xml.ws.Service.Mode.MESSAGE)
public class Hello2Impl implements Provider<SOAPMessage> {

    public SOAPMessage invoke(SOAPMessage req)  {
	System.out.println("**** Received in Provider Impl Hello2Impl ******");
	System.out.println("->    SOAPMessage received="+req);
	JAXWS_Util.dumpSOAPMessage(req, false);
     SOAPMessage respMsg = null;
	try {

         String helloResp = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Body><HelloResponse xmlns=\"http://helloservice.org/types\"><argument>responseBean</argument></HelloResponse></soapenv:Body></soapenv:Envelope>";

         respMsg = JAXWS_Util.makeSOAPMessage(helloResp);
         respMsg.saveChanges();
	}
	catch (Exception e) {
	    System.out.println("Exception: occurred " + e);
	}
	System.out.println("->    SOAPMessage being returned="+respMsg);
	JAXWS_Util.dumpSOAPMessage(respMsg, false);

     return respMsg;
    }

}
