/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HelloImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.w2j.document.literal.customization.external;

import com.sun.ts.tests.jaxws.ee.w2j.document.literal.customization.external.custom.pkg.CustomizationExternalTestException;


import javax.jws.WebService;

@WebService(
    portName="HelloPort",
    serviceName="myService",
    targetNamespace="http://customizationexternaltest.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/WSW2JDLCustomizationExternalTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.ee.w2j.document.literal.customization.external.Hello"
)

public class HelloImpl implements Hello {
    public void myHello(javax.xml.ws.Holder<HelloElement> helloArgument) throws CustomizationExternalTestException {
            System.out.println("in CustomizationExternalTestService:HelloImpl:myHello");
	    if (helloArgument.value.getArgument().equals("Exception Case")) {
		HelloFaultMessage hfm = new HelloFaultMessage();
		hfm.setFault1("foo");
		hfm.setFault2("bar");
		throw new CustomizationExternalTestException("This is the CustomizationExternalTestException fault", hfm);
	    }
	    else
                helloArgument.value.setArgument(helloArgument.value.getArgument()+", World!");
    }
    
}
