/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.api.javax_xml_ws.RespectBindingFeature;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import java.math.*;

import javax.xml.ws.RespectBindingFeature;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{
   
    public static void main(String[] args) 
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }  
    
    /*
     *   @testName:  RespectBindingFeatureConstructorTest
     *
     *   @assertion_ids: JAXWS:JAVADOC:151;
     *
     *   @test_Strategy: Create instance via RespectBindingFeature() constructor.
     *			Verify RespectBindingFeature object created successfully.
     */
    public void RespectBindingFeatureConstructorTest() throws Fault {
	TestUtil.logTrace("RespectBindingFeatureConstructorTest");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via RespectBindingFeature() ...");
	    RespectBindingFeature n = new RespectBindingFeature();
	    if (n != null) {
		if (!(n.isEnabled())) {
                    TestUtil.logErr("RespectBindingFeature object created successfully, but RespectBindingFeature is not enabled");
                    pass = false;
                } else {
                    TestUtil.logMsg("RespectBindingFeature object created successfully");
                }
	    } else {
		TestUtil.logErr("RespectBindingFeature object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("RespectBindingFeatureConstructorTest failed", e);
        }

	if (!pass) {
	    throw new Fault("RespectBindingFeatureConstructorTest failed");
        }
    }     
    
    /*
     *   @testName:  RespectBindingFeatureConstructorTest2
     *
     *   @assertion_ids: JAXWS:JAVADOC:152;
     *
     *   @test_Strategy: Create instance via RespectBindingFeature(true) constructor.
     *			Verify RespectBindingFeature object created successfully.
     */
    public void RespectBindingFeatureConstructorTest2() throws Fault {
	TestUtil.logTrace("RespectBindingFeatureConstructorTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via RespectBindingFeature(true) ...");
	    RespectBindingFeature n = new RespectBindingFeature(true);
	    if (n != null) {
		if (!(n.isEnabled())) {
                    TestUtil.logErr("RespectBindingFeature object created successfully, but RespectBinding is not enabled");
                    pass = false;
                } else {
                    TestUtil.logMsg("RespectBindingFeature object created successfully");
                }
	    } else {
		TestUtil.logErr("RespectBindingFeature object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("RespectBindingFeatureConstructorTest2 failed", e);
        }

	if (!pass) {
	    throw new Fault("RespectBindingFeatureConstructorTest2 failed");
        }
    }
    
    /*
     *   @testName:  RespectBindingFeatureConstructorTest3
     *
     *   @assertion_ids: JAXWS:JAVADOC:152;
     *
     *   @test_Strategy: Create instance via RespectBindingFeature(false) constructor.
     *			Verify RespectBindingFeature object created successfully.
     */
    public void RespectBindingFeatureConstructorTest3() throws Fault {
	TestUtil.logTrace("RespectBindingFeatureConstructorTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via RespectBindingFeature(false) ...");
	    RespectBindingFeature n = new RespectBindingFeature(false);
	    if (n != null) {
		if (!(n.isEnabled())) {
                    TestUtil.logMsg("RespectBindingFeature object created successfully, RespectBinding is correctly not enabled");
                } else {
                    TestUtil.logErr("RespectBindingFeature object created successfully, but RespectBinding is incorrectly enabled.");
                    pass = false;
                }
	    } else {
		TestUtil.logErr("RespectBindingFeature object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("RespectBindingFeatureConstructorTest3 failed", e);
        }

	if (!pass) {
	    throw new Fault("RespectBindingFeatureConstructorTest3 failed");
        }
    }    
              
    /*
     *   @testName:  getIDTest
     *
     *   @assertion_ids: JAXWS:JAVADOC:150; 
     *
     *   @test_Strategy: Test getting the unique identifier for this RespectBindingFeature object.
     *			 Verify value returned is set correctly.
     */
    public void getIDTest() throws Fault {
	TestUtil.logTrace("getIDTest");
	boolean pass = true;
        
        try {
	    TestUtil.logMsg("Create instance via RespectBindingFeature(true) ...");
	    RespectBindingFeature n = new RespectBindingFeature(true);
	    if (n != null) {
		if (!(RespectBindingFeature.ID.equals(n.getID()))) {
                    TestUtil.logErr("RespectBindingFeature object created with incorrect ID, expected ["+RespectBindingFeature.ID+"], received ["+n.getID()+"]");
                    pass = false;
                } else {
                    TestUtil.logMsg("RespectBindingFeature object created successfully with correct ID, expected ["+RespectBindingFeature.ID+"], received ["+n.getID()+"]");
                }
	    } else {
		TestUtil.logErr("RespectBindingFeature object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("getIDTest failed", e);
        }
        
	if (!pass) {
	    throw new Fault("getIDTest failed");
        }
    }                
    
    
    /*
     *   @testName:  isEnabledTest
     *
     *   @assertion_ids: JAXWS:JAVADOC:161; 
     *
     *   @test_Strategy: Test setting isEnabled of RespectBindingFeature object.
     *			 Get enabled value and verify value returned is set correctly.
     */
    public void isEnabledTest() throws Fault {
	TestUtil.logTrace("isEnabledTest");
	boolean pass = true;
        
        try {
	    TestUtil.logMsg("Create instance via RespectBindingFeature() ...");
	    RespectBindingFeature n = new RespectBindingFeature();
	    if (n != null) {
		boolean isEnabled = n.isEnabled();
                if (isEnabled == true) {
                    // got returned correct value, now try setting it to new value
                    TestUtil.logMsg("Returned correct isEnabled value, received ["+n.isEnabled()+"]");                   
                } else {
                    TestUtil.logMsg("Returned incorrect isEnabled value, expected ["+new Boolean(true)+"], received ["+n.isEnabled()+"]");                  
                    pass = false;
                }
                // now create with enabled set to false, verify isEnabled correctly returns false
                TestUtil.logMsg("Create instance via RespectBindingFeature(false) ...");
	        RespectBindingFeature n1 = new RespectBindingFeature(false);
	        if (n1 != null) {
		    isEnabled = n1.isEnabled();
                    if (isEnabled == false) {
                        // got returned correct value, now try setting it to new value
                        TestUtil.logMsg("Returned correct isEnabled value, received ["+n1.isEnabled()+"]");                   
                    } else {
                        TestUtil.logMsg("Returned incorrect isEnabled value, expected ["+new Boolean(false)+"], received ["+n1.isEnabled()+"]");                  
                        pass = false;
                    }
                } else {
		    TestUtil.logErr("RespectBindingFeature object not created for constructor RespectBindingFeature(false)");
		    pass = false;
	        }
	    } else {
		TestUtil.logErr("RespectBindingFeature object not created for default constructor RespectBindingFeature()");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("isEnabledTest failed", e);
        }
        
	if (!pass) {
	    throw new Fault("isEnabledTest failed");
        }
    }
           
}
