/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: JAXBAsyncHandler.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.api.javax_xml_ws.AsyncHandler;

import com.sun.ts.tests.jaxws.sharedclients.doclithelloclient.*;

import com.sun.ts.lib.util.*;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;

public class JAXBAsyncHandler implements AsyncHandler<Object> 
{
	private boolean dataReady = false;
	private HelloResponse theData;
	private java.util.Map<String,Object> theContext;

	public JAXBAsyncHandler(){
	    TestUtil.logMsg("in JAXBAsyncHandler");
	}

	public synchronized boolean isDataReady() { return dataReady; }
	public HelloResponse getData() { return theData; }
	public java.util.Map<String,Object> getContext() { return theContext; }

	public void handleResponse(Response<Object> res) {
	    TestUtil.logMsg("in JAXBAsyncHandler.handleResponse()");
	    try {
		theData = (HelloResponse) res.get();
		theContext = res.getContext();
	    }
	    catch (Exception e) {
		e.printStackTrace();
	    }
	    synchronized (this) {
		dataReady = true;
	    }

	}
}
