/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.ssh.AbstractSshMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;

public class ScpToMessage
extends AbstractSshMessage {
    private static final int HUNDRED_KILOBYTES = 102400;
    private static final int BUFFER_SIZE = 102400;
    private static final int DEFAULT_DIR_MODE = 493;
    private static final int DEFAULT_FILE_MODE = 420;
    private File localFile;
    private String remotePath;
    private List directoryList;
    private Integer fileMode;
    private Integer dirMode;
    private boolean preserveLastModified;

    public ScpToMessage(Session session) {
        super(session);
    }

    public ScpToMessage(boolean verbose, Session session) {
        super(verbose, session);
    }

    public ScpToMessage(boolean verbose, Session session, File aLocalFile, String aRemotePath, boolean preserveLastModified) {
        this(verbose, session, aRemotePath);
        this.localFile = aLocalFile;
        this.preserveLastModified = preserveLastModified;
    }

    public ScpToMessage(boolean verbose, Session session, List aDirectoryList, String aRemotePath, boolean preserveLastModified) {
        this(verbose, session, aRemotePath);
        this.directoryList = aDirectoryList;
        this.preserveLastModified = preserveLastModified;
    }

    public ScpToMessage(boolean verbose, Session session, File aLocalFile, String aRemotePath) {
        this(verbose, session, aLocalFile, aRemotePath, false);
    }

    public ScpToMessage(boolean verbose, Session session, List aDirectoryList, String aRemotePath) {
        this(verbose, session, aDirectoryList, aRemotePath, false);
    }

    private ScpToMessage(boolean verbose, Session session, String aRemotePath) {
        super(verbose, session);
        this.remotePath = aRemotePath;
    }

    public ScpToMessage(Session session, File aLocalFile, String aRemotePath) {
        this(false, session, aLocalFile, aRemotePath);
    }

    public ScpToMessage(Session session, List aDirectoryList, String aRemotePath) {
        this(false, session, aDirectoryList, aRemotePath);
    }

    public void execute() throws IOException, JSchException {
        if (this.directoryList != null) {
            this.doMultipleTransfer();
        }
        if (this.localFile != null) {
            this.doSingleTransfer();
        }
        this.log("done.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSingleTransfer() throws IOException, JSchException {
        String cmd = "scp -t " + (this.getPreserveLastModified() ? "-p " : "") + this.remotePath;
        Channel channel = this.openExecChannel(cmd);
        try {
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            this.waitForAck(in);
            this.sendFileToRemote(this.localFile, in, out);
            Object var6_5 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        channel.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doMultipleTransfer() throws IOException, JSchException {
        Channel channel = this.openExecChannel("scp -r -d -t " + (this.getPreserveLastModified() ? "-p " : "") + this.remotePath);
        try {
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            this.waitForAck(in);
            for (Directory current : this.directoryList) {
                this.sendDirectory(current, in, out);
            }
            Object var7_6 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        channel.disconnect();
    }

    private void sendDirectory(Directory current, InputStream in, OutputStream out) throws IOException {
        Iterator fileIt = current.filesIterator();
        while (fileIt.hasNext()) {
            this.sendFileToRemote((File)fileIt.next(), in, out);
        }
        Iterator dirIt = current.directoryIterator();
        while (dirIt.hasNext()) {
            Directory dir = (Directory)dirIt.next();
            this.sendDirectoryToRemote(dir, in, out);
        }
    }

    private void sendDirectoryToRemote(Directory directory, InputStream in, OutputStream out) throws IOException {
        String command = "D0";
        command = command + Integer.toOctalString(this.getDirMode());
        command = command + " 0 ";
        command = command + directory.getDirectory().getName();
        command = command + "\n";
        out.write(command.getBytes());
        out.flush();
        this.waitForAck(in);
        this.sendDirectory(directory, in, out);
        out.write("E\n".getBytes());
        out.flush();
        this.waitForAck(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFileToRemote(File localFile, InputStream in, OutputStream out) throws IOException {
        String command;
        long filesize = localFile.length();
        if (this.getPreserveLastModified()) {
            command = "T" + localFile.lastModified() / 1000L + " 0";
            command = command + " " + localFile.lastModified() / 1000L + " 0\n";
            out.write(command.getBytes());
            out.flush();
            this.waitForAck(in);
        }
        command = "C0";
        command = command + Integer.toOctalString(this.getFileMode());
        command = command + " " + filesize + " ";
        command = command + localFile.getName();
        command = command + "\n";
        out.write(command.getBytes());
        out.flush();
        this.waitForAck(in);
        FileInputStream fis = new FileInputStream(localFile);
        byte[] buf = new byte[102400];
        long startTime = System.currentTimeMillis();
        long totalLength = 0L;
        boolean trackProgress = this.getVerbose() && filesize > 102400L;
        long initFilesize = filesize;
        int percentTransmitted = 0;
        try {
            int len;
            if (this.getVerbose()) {
                this.log("Sending: " + localFile.getName() + " : " + localFile.length());
            }
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                totalLength += (long)len;
                if (!trackProgress) continue;
                percentTransmitted = this.trackProgress(initFilesize, totalLength, percentTransmitted);
            }
            out.flush();
            this.sendAck(out);
            this.waitForAck(in);
            Object var19_14 = null;
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            if (this.getVerbose()) {
                long endTime = System.currentTimeMillis();
                this.logStats(startTime, endTime, totalLength);
            }
            fis.close();
            throw throwable;
        }
        if (this.getVerbose()) {
            long endTime = System.currentTimeMillis();
            this.logStats(startTime, endTime, totalLength);
        }
        fis.close();
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public int getFileMode() {
        return this.fileMode != null ? this.fileMode : 420;
    }

    public void setDirMode(int dirMode) {
        this.dirMode = dirMode;
    }

    public int getDirMode() {
        return this.dirMode != null ? this.dirMode : 493;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }
}

