/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: R2753Handler.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/*
 * @(#)R2753Handler.java	1.3 03/06/06
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2753;

import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.namespace.QName;
import javax.xml.soap.*;

public class R2753Handler extends GenericHandler{
    public QName[] getHeaders(){return new QName[]{new QName("http://extra-header.org", "extra-header")};}

    public boolean handleRequest(MessageContext context){
        handle(context);
        return true;
    }

    public boolean handleResponse(MessageContext context){
        handle(context);
        return true;
    }

    private void handle(MessageContext context) {
        try{
            addExtraHeader((SOAPMessageContext)context);
        }catch(SOAPException se){
            com.sun.ts.lib.util.TestUtil.printStackTrace(se);
        }
    }

    private void addExtraHeader(SOAPMessageContext context) throws SOAPException{
        SOAPEnvelope env = context.getMessage().getSOAPPart().getEnvelope();
        if(env.getHeader() == null){
            SOAPHeader header = env.addHeader();
            SOAPHeaderElement extraHeader = header.addHeaderElement(getExtraHeaderName(env));
            extraHeader.setActor("extra-header-actor");
            extraHeader.setMustUnderstand(true);
	    context.getMessage().saveChanges();
        }
    }

    private Name getExtraHeaderName(SOAPEnvelope env) throws SOAPException{
        return env.createName("extra-header", "ns1", "http://extra-header.org");
    }
}
