/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JDLR2747ClientOne.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.document.literal.R2747;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;

public class W2JDLR2747ClientOne extends SOAPClient {
    public W2JDLR2747ClientOne(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jdlr2747testservice.org/W2JDLR2747TestService.wsdl");
        stubContext.setService("W2JDLR2747TestService");
        stubContext.setPortPrefix("W2JDLR2747TestOne");
        stubContext.setServiceInterface(W2JDLR2747TestOne.class);
    }

    protected String getEndpointURLProperty() {
        return CTSConstants.w2jdlr2747EndpointOneProperty;
    }

    protected String getWSDLURLProperty() {
        return CTSConstants.w2jdlr2747WSDLOneProperty;
    }

    public String echoString(String str) throws Exception {
        return ((W2JDLR2747TestOne)stubContext.getStub()).echoString(str);
    }
}
