/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: PropertyUtils.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/*
 * @(#)PropertyUtils.java	1.2 03/05/16
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.utils;

import java.util.Properties;

import com.sun.ts.lib.harness.EETest;

/**
 */
public class PropertyUtils {
    /**
     * Returns the property with the specified name.  If the property does not exist,
     * an EETest.Fault exception is thrown.
     * 
     * @param properties the properties.
     * @param key the key.
     * 
     * @return the value.
     * 
     * @throws EETest.Fault
     */
    public static String getProperty(Properties properties, String key) throws EETest.Fault {
        String value = properties.getProperty(key);
        if (value != null) {
            return value;
        }
        throw new EETest.Fault("Required property '" + key + "' not present.");
	}
	
    /**
     * Returns the property, with the specified name, as an integer.
     * If the property does not exist or cannot be converted to an integer,
     * an EETest.Fault exception is thrown.
     * 
     * @param properties the properties.
     * @param key the key.
     * 
     * @return the value.
     * 
     * @throws EETest.Fault
     */
	public static int getIntegerProperty(Properties properties, String key) throws EETest.Fault {
		String value = getProperty(properties, key);
		try {
            int i = Integer.parseInt(value);
            return i;
		} catch (NumberFormatException e) {
            throw new EETest.Fault("Property '" + key + "' value '" + value + "' is not a valid integer.", e);
		}
	}
	
    /**
     * Returns the property, with the specified name, as a boolean.
     * If the property does not exist or cannot be converted to a boolean,
     * an EETest.Fault exception is thrown.
     * 
     * @param properties the properties.
     * @param key the key.
     * 
     * @return the value.
     * 
     * @throws EETest.Fault
     */
    public static boolean getBooleanProperty(Properties properties, String key) throws EETest.Fault {
        String value = getProperty(properties, key);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new EETest.Fault("Property '" + key + "' value '" + value + "' is not a valid boolean.");
    }
    
    /**
     * Private to prevent instantiation.
     */
    private PropertyUtils() {
        super();
    }
}
