/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: SingleElementIterator.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.lang.UnsupportedOperationException;
import java.lang.IllegalStateException;

/**
 * An Iterator on a single element collection.
 */
public class SingleElementIterator implements Iterator {
    protected boolean hasNext = false;
    protected Object element;

    public SingleElementIterator() {
    }
    public SingleElementIterator(Object element) {
        this.element = element;
        hasNext = true;
    }
    public boolean hasNext() {
        return hasNext;
    }
    public Object next() throws NoSuchElementException {
        if (!hasNext) {
            throw new NoSuchElementException(
		"No elements left in SingleElementIterator next()");
        }
        hasNext = false;
        return element;
    }
    public void remove() throws UnsupportedOperationException,
						IllegalStateException {
        throw new UnsupportedOperationException(
		"SingleElementIterator does not support remove()");
    }
}
