/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: JBIVehicleRunner.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.jbi;

import java.io.*;
import java.util.*;
import com.sun.ts.lib.harness.*;
import com.sun.javatest.*;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.tests.jbi.*;
import com.sun.ts.tests.common.vehicle.*;

public class JBIVehicleRunner implements VehicleRunnable {

    public Status run(String[] argv, Properties p) {
        String sVehicle = p.getProperty("vehicle");
	Result res = null;
        try {
	    String testClass = p.getProperty("test_classname");
            p.setProperty("test.class", testClass);
	    ServiceRequest noRequest = new ServiceRequest("no-request", p);
	    String rmiRegHost   = p.getProperty("jbi.rmi.host", "localhost");
	    int    rmiRegPort   = Integer.parseInt(p.getProperty("jbi.rmi.port", "1099"));
	    String rmiBoundName = p.getProperty("jbi.vehicle.rmi.bound.name", "signaturetest.jbi.JBIVehicle");
	    TestUtil.logMsg("rmiRegHost   = " + rmiRegHost);
	    TestUtil.logMsg("rmiRegPort   = " + rmiRegPort);
	    TestUtil.logMsg("rmiBoundName = " + rmiBoundName);
	    TestUtil.logMsg("testClass = " + testClass);
	    RemoteComponentInterface jbiVehicle = (RemoteComponentInterface)
		RegistryUtils.lookup(rmiRegHost, rmiRegPort, rmiBoundName);
	    res = jbiVehicle.invoke(noRequest);
        } catch(Exception e) {
            TestUtil.logErr("Exception caught in JBIVehicleRunner.run()", e);
	    res = new Result(false, "Exception caught in JBIVehicleRunner.run() " + e);
        }
        return res.asStatus();
    }
    
}  
  
