/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.registry.RegistryException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freebxml.omar.common.CommonProperties;
import org.freebxml.omar.common.CredentialInfo;
import org.freebxml.omar.common.RepositoryItem;
import org.freebxml.omar.common.RepositoryItemImpl;
import org.freebxml.omar.common.security.PayloadResolver;
import org.freebxml.omar.common.security.X509KeySelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecurityUtil {
    private static SecurityUtil instance = null;
    private Log log = LogFactory.getLog(this.getClass());
    private static PrivateKey dummyPK = null;
    static /* synthetic */ Class class$org$freebxml$omar$common$security$SecurityUtil;

    protected SecurityUtil() {
    }

    public void signSOAPMessage(InputStream soapStream, OutputStream signedSoapStream, String alias, PrivateKey privateKey, Certificate[] certs, String signatureAlgo) throws RegistryException {
        try {
            XMLSignatureFactory fac = this.createXMLSignatureFactory();
            Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureAlgo, null), Collections.singletonList(ref));
            KeyInfo ki = this.createKeyInfo(fac, alias, (X509Certificate)certs[0]);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new InputSource(soapStream));
            Element envelope = doc.getDocumentElement();
            Element header = SecurityUtil.getFirstChildElement(envelope);
            DOMSignContext dsc = new DOMSignContext(privateKey, (Node)header);
            XMLSignature signature = fac.newXMLSignature(si, ki);
            signature.sign(dsc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(doc), new StreamResult(signedSoapStream));
        }
        catch (IOException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (SAXException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new RegistryException((Throwable)e);
        }
    }

    private static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public RepositoryItem signPayload(DataHandler dh, String id, CredentialInfo credentialInfo) throws RegistryException {
        RepositoryItemImpl ri = null;
        try {
            XMLSignatureFactory fac = this.createXMLSignatureFactory();
            Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            String signingAlgo = credentialInfo.privateKey.getAlgorithm();
            if (signingAlgo.equalsIgnoreCase("DSA")) {
                signingAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (signingAlgo.equalsIgnoreCase("RSA")) {
                signingAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else if (signingAlgo.equalsIgnoreCase("HMAC")) {
                signingAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
            } else {
                throw new RegistryException("Signature algorithm not supported");
            }
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signingAlgo, null), Collections.singletonList(ref));
            KeyInfo ki = this.createKeyInfo(fac, credentialInfo.alias, credentialInfo.cert);
            XMLSignature signature = fac.newXMLSignature(si, ki);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            DOMSignContext signContext = new DOMSignContext(credentialInfo.privateKey, (Node)doc);
            PayloadResolver payloadURIDereferencer = new PayloadResolver(dh);
            signContext.setURIDereferencer(payloadURIDereferencer);
            signature.sign(signContext);
            Element sigElement = doc.getDocumentElement();
            ri = new RepositoryItemImpl(id, sigElement, dh);
        }
        catch (ParserConfigurationException e) {
            throw new RegistryException("Cannot sign the payload", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new RegistryException((Throwable)e);
        }
        return ri;
    }

    public XMLSignature verifySOAPMessage(SOAPMessage msg, KeySelector keySelector) throws RegistryException {
        XMLSignature signature = null;
        try {
            DOMValidateContext valContext;
            ByteArrayOutputStream msgOutStream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)msgOutStream);
            ByteArrayInputStream msgInStream = new ByteArrayInputStream(msgOutStream.toByteArray());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(msgInStream));
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                return null;
            }
            XMLSignatureFactory fac = this.createXMLSignatureFactory();
            signature = fac.unmarshalXMLSignature(valContext = new DOMValidateContext(keySelector, nl.item(0)));
            boolean coreValidity = signature.validate(valContext);
            if (!coreValidity) {
                String errorMsg = "Signature failed core validation";
                boolean sv = signature.getSignatureValue().validate(valContext);
                errorMsg = errorMsg + "\n   signature validation status: " + sv;
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    boolean refValid = i.next().validate(valContext);
                    errorMsg = errorMsg + "\n   ref[" + j + "] validity status: " + refValid;
                    ++j;
                }
                throw new XMLSignatureException(errorMsg);
            }
        }
        catch (Exception e) {
            this.handleHeaderVerificationException(e);
        }
        return signature;
    }

    private void handleHeaderVerificationException(Exception e) throws RegistryException {
        boolean ignoreInvalidHeaderSignatures = Boolean.valueOf(CommonProperties.getInstance().getProperty("omar.common.security.ignoreInvalidHeaderSignatures", "true"));
        if (!ignoreInvalidHeaderSignatures) {
            throw new RegistryException("Invalid header signature. The message may have been tampered with in transit.", (Throwable)e);
        }
        this.log.error((Object)("Invalid header signature. The message may have been tampered with in transit. Ignored because omar.common.security.ignoreInvalidHeaderSignatures is set to true." + e.toString()));
    }

    public boolean verifyPayloadSignature(String id, RepositoryItem ri, X509KeySelector keySelector) throws RegistryException {
        boolean ignoreInvalidPayloadSignatures;
        boolean isValid = false;
        String errorMsg = null;
        try {
            Element sigElement = ri.getSignatureElement();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DOMValidateContext valContext = new DOMValidateContext(keySelector, (Node)sigElement);
            PayloadResolver payloadURIDereferencer = new PayloadResolver(ri.getDataHandler());
            valContext.setURIDereferencer(payloadURIDereferencer);
            XMLSignatureFactory fac = this.createXMLSignatureFactory();
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            if (!coreValidity) {
                errorMsg = "Signature failed core validation";
                boolean sv = signature.getSignatureValue().validate(valContext);
                errorMsg = errorMsg + "\n   signature validation status: " + sv;
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference ref = i.next();
                    boolean refValid = ref.validate(valContext);
                    errorMsg = errorMsg + "\n   ref[" + j + "]= '" + ref.getId() + "' validity status: " + refValid;
                    ++j;
                }
            }
            isValid = coreValidity;
        }
        catch (Exception e) {
            this.handlePayloadVerificationException(e);
        }
        if (!isValid && (ignoreInvalidPayloadSignatures = Boolean.valueOf(CommonProperties.getInstance().getProperty("omar.common.security.ignoreInvalidPayloadSignatures")).booleanValue())) {
            isValid = true;
            this.log.error((Object)("Cannot verify the payload signature.\n  " + errorMsg + "\n    Ignored because omar.common.security.ignoreInvalidPayloadSignatures is set to true."));
        }
        return isValid;
    }

    private void handlePayloadVerificationException(Exception e) throws RegistryException {
        boolean ignoreInvalidPayloadSignatures = Boolean.valueOf(CommonProperties.getInstance().getProperty("omar.common.security.ignoreInvalidPayloadSignatures"));
        if (!ignoreInvalidPayloadSignatures) {
            throw new RegistryException("Cannot verify the payload signature", (Throwable)e);
        }
        this.log.error((Object)("Cannot verify the payload signature. Ignored because omar.common.security.ignoreInvalidPayloadSignatures is set to true. " + e.toString()));
    }

    public XMLSignature unmarshalSignature(Element signatureElement) throws RegistryException {
        XMLSignature signature = null;
        try {
            String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            DOMValidateContext valContext = new DOMValidateContext(new KeyValueKeySelector(), (Node)signatureElement);
            signature = fac.unmarshalXMLSignature(valContext);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        return signature;
    }

    public XMLSignatureFactory createXMLSignatureFactory() throws RegistryException {
        try {
            String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            return fac;
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RegistryException((Throwable)e);
        }
    }

    private KeyInfo createKeyInfo(XMLSignatureFactory fac, String alias, X509Certificate cert) throws RegistryException {
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<XMLStructure> keyInfoList = new ArrayList<XMLStructure>();
        if (alias != null && !alias.trim().equals("")) {
            KeyName keyName = kif.newKeyName(alias);
            keyInfoList.add(keyName);
            ArrayList<String> x509DataList = new ArrayList<String>();
            x509DataList.add(alias);
            X509Data x509Data = kif.newX509Data(x509DataList);
            keyInfoList.add(x509Data);
        } else {
            ArrayList<X509Certificate> x509DataList = new ArrayList<X509Certificate>();
            x509DataList.add(cert);
            X509Data x509Data = kif.newX509Data(x509DataList);
            keyInfoList.add(x509Data);
        }
        KeyInfo ki = kif.newKeyInfo(Collections.unmodifiableList(keyInfoList));
        return ki;
    }

    public static void main(String[] unused) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityUtil getInstance() {
        if (instance == null) {
            Class clazz = class$org$freebxml$omar$common$security$SecurityUtil == null ? (class$org$freebxml$omar$common$security$SecurityUtil = SecurityUtil.class$("org.freebxml.omar.common.security.SecurityUtil")) : class$org$freebxml$omar$common$security$SecurityUtil;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new SecurityUtil();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (!(xmlStructure instanceof KeyValue)) continue;
                PublicKey pk = null;
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException ke) {
                    throw new KeySelectorException(ke);
                }
                if (!KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }

        static boolean algEquals(String algURI, String algName) {
            if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return true;
            }
            return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

