/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.PropertyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freebxml.omar.common.CommonProperties;
import org.freebxml.omar.common.CredentialInfo;

public class SecurityCallbackHandler
implements CallbackHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$freebxml$omar$common$security$SecurityCallbackHandler == null ? (class$org$freebxml$omar$common$security$SecurityCallbackHandler = SecurityCallbackHandler.class$("org.freebxml.omar.common.security.SecurityCallbackHandler")) : class$org$freebxml$omar$common$security$SecurityCallbackHandler));
    public static final String KEY_MAX_CLOCK_SKEW = "omar.common.security.maxClockSkew";
    protected CredentialInfo credentialInfo;
    static /* synthetic */ Class class$org$freebxml$omar$common$security$SecurityCallbackHandler;

    public SecurityCallbackHandler(CredentialInfo credentialInfo) {
        if (credentialInfo == null) {
            throw new IllegalArgumentException("'credentialInfo' cannot be null.");
        }
        this.credentialInfo = credentialInfo;
    }

    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            SignatureKeyCallback.PrivKeyCertRequest request;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling callback: " + callbacks[i].getClass().getName()));
            }
            if (callbacks[i] instanceof SignatureKeyCallback) {
                request = (SignatureKeyCallback.PrivKeyCertRequest)((SignatureKeyCallback)callbacks[i]).getRequest();
                request.setPrivateKey(this.credentialInfo.privateKey);
                request.setX509Certificate(this.credentialInfo.cert);
                continue;
            }
            if (callbacks[i] instanceof SignatureVerificationKeyCallback) {
                try {
                    request = (SignatureVerificationKeyCallback.X509CertificateRequest)((SignatureVerificationKeyCallback)callbacks[i]).getRequest();
                    request.setX509Certificate(this.credentialInfo.cert);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (callbacks[i] instanceof CertificateValidationCallback) {
                CertificateValidationCallback cb = (CertificateValidationCallback)callbacks[i];
                cb.setValidator((CertificateValidationCallback.CertificateValidator)new X509CertificateValidatorImpl());
                continue;
            }
            if (callbacks[i] instanceof PropertyCallback) {
                String maxClockSkew = CommonProperties.getInstance().getProperty(KEY_MAX_CLOCK_SKEW);
                if (maxClockSkew == null) continue;
                try {
                    PropertyCallback cb = (PropertyCallback)callbacks[i];
                    cb.setMaxClockSkew(Long.parseLong(maxClockSkew));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid (long) value for property 'omar.common.security.maxClockSkew':" + maxClockSkew), (Throwable)e);
                }
                continue;
            }
            log.warn((Object)("UNSUPPORTED callback: " + callbacks[i].getClass().getName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class X509CertificateValidatorImpl
    implements CertificateValidationCallback.CertificateValidator {
        private X509CertificateValidatorImpl() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            if (this.isSelfCert(certificate)) {
                return true;
            }
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                e.printStackTrace();
                throw new CertificateValidationCallback.CertificateValidationException("X509Certificate Expired", (Throwable)e);
            }
            catch (CertificateNotYetValidException e) {
                e.printStackTrace();
                throw new CertificateValidationCallback.CertificateValidationException("X509Certificate not yet valid", (Throwable)e);
            }
            return true;
        }

        private boolean isSelfCert(X509Certificate cert) throws CertificateValidationCallback.CertificateValidationException {
            return true;
        }
    }
}

