/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.org.apache.xml.security.signature.XMLSignature;
import com.sun.org.apache.xml.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.XWSSecurityException;
import java.io.IOException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class ExtendedSignatureHeaderBlock
extends SignatureHeaderBlock {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    protected SOAPMessage soapMessage;

    public ExtendedSignatureHeaderBlock(XMLSignature signature) throws XWSSecurityException {
        super(signature);
    }

    public ExtendedSignatureHeaderBlock(SOAPElement elem) throws XWSSecurityException {
        super(elem);
    }

    public ExtendedSignatureHeaderBlock(Document doc, String signatureMethodURI) throws XWSSecurityException {
        super(doc, signatureMethodURI);
    }

    public void sign(Key signingKey) throws XWSSecurityException {
        try {
            XMLSignature signature = this.getSignature();
            signature.addResourceResolver(new ResourceResolver((ResourceResolverSpi)new CIDResourceResolverSpi()));
            signature.sign(signingKey);
            this.saveChanges();
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0323.exception.while.signing", e);
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public boolean checkSignatureValue(Key pk) throws XWSSecurityException {
        boolean bool;
        try {
            XMLSignature signature = this.getSignature();
            signature.addResourceResolver(new ResourceResolver((ResourceResolverSpi)new CIDResourceResolverSpi()));
            bool = signature.checkSignatureValue(pk);
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0326.exception.verifying.signature", e);
            throw new XWSSecurityException((Throwable)e);
        }
        return bool;
    }

    public boolean checkSignatureValue(X509Certificate cert) throws XWSSecurityException {
        boolean bool;
        try {
            XMLSignature signature = this.getSignature();
            signature.addResourceResolver(new ResourceResolver((ResourceResolverSpi)new CIDResourceResolverSpi()));
            bool = signature.checkSignatureValue(cert);
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0326.exception.verifying.signature", e);
            throw new XWSSecurityException((Throwable)e);
        }
        return bool;
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public void setSoapMessage(SOAPMessage soapMessage) {
        this.soapMessage = soapMessage;
    }

    class CIDResourceResolverSpi
    extends ResourceResolverSpi {
        CIDResourceResolverSpi() {
        }

        public boolean engineCanResolve(Attr uri, String base) {
            return uri.getValue().startsWith("cid:");
        }

        public XMLSignatureInput engineResolve(Attr uri, String base) {
            block5: {
                try {
                    MimeHeaders headers = new MimeHeaders();
                    headers.addHeader("Content-ID", "<" + uri.getValue().substring("cid:".length()) + ">");
                    Iterator attachments = ExtendedSignatureHeaderBlock.this.soapMessage.getAttachments(headers);
                    if (!attachments.hasNext()) {
                        log.log(Level.SEVERE, "No attachment resource for URI: " + uri);
                        break block5;
                    }
                    AttachmentPart attachment = (AttachmentPart)attachments.next();
                    if (attachments.hasNext()) {
                        log.log(Level.SEVERE, "Multiple attachment resource for URI: " + uri);
                        break block5;
                    }
                    return new XMLSignatureInput(attachment.getDataHandler().getInputStream());
                }
                catch (SOAPException e) {
                    log.log(Level.SEVERE, "Exception resolving URI: " + uri, e);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Exception resolving URI: " + uri, e);
                }
            }
            return new XMLSignatureInput("");
        }
    }
}

