/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SecurityHeaderBlock;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;

public class ExtendedExportCertificateTokenFilter
extends FilterBase
implements MessageFilter {
    protected String alias;
    protected String wsuId;
    protected X509Certificate cert;

    public ExtendedExportCertificateTokenFilter(String alias, String wsuId) {
        this.alias = alias;
        this.wsuId = wsuId;
    }

    public ExtendedExportCertificateTokenFilter(X509Certificate cert, String wsuId) {
        this.cert = cert;
        this.wsuId = wsuId;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findOrCreateSecurityHeader();
        if (this.cert == null) {
            this.cert = secureMessage.getSecurityEnvironment().getCertificate(this.alias, true);
        }
        this.exportCertificateToken(secureMessage, wsseSecurity, this.cert, this.wsuId);
    }

    protected void exportCertificateToken(SecurableSoapMessage ssm, SecurityHeader wsseSecurity, X509Certificate cert, String wsuId) throws XWSSecurityException {
        X509SecurityToken token = new X509SecurityToken((Document)ssm.getSOAPPart(), cert, wsuId);
        ssm.setToken(wsuId, (SecurityToken)token);
        wsseSecurity.insertHeaderBlock((SecurityHeaderBlock)token);
    }
}

