/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover.markup;

import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.plugin.FormatAdapter;
import com.sun.tdk.signaturetest.plugin.ReaderAdapter;
import com.sun.tdk.signaturetest.sigfile.FileManager;

public class Adapter {
    public static final Modifier coverIgnore = new Modifier("!cover-ignore", true);

    public Adapter(FileManager fm) {
        for (MemberType mt : MemberType.knownTypes) {
            mt.setModifiersMask(mt.getModifiersMask() | coverIgnore.getValue());
        }
        FormatAdapter f = new FormatAdapter("#APICover file v4.1");
        f.setReader(new ReaderAdapter(f){
            boolean covOn;
            {
                this.covOn = false;
            }

            protected String preprocessLine(String currentLine) {
                if (currentLine != null) {
                    String st = currentLine.trim();
                    if (st.equals("#coverage off")) {
                        this.covOn = false;
                    } else if (st.equals("#coverage on")) {
                        this.covOn = true;
                    } else if (!("".equals(st) || this.covOn || st.startsWith("#") || st.startsWith("anno") || st.startsWith("hfds") || st.startsWith("hcls"))) {
                        currentLine = currentLine.replaceFirst(" ", " " + coverIgnore.toString() + " ");
                    }
                }
                return super.preprocessLine(currentLine);
            }
        });
        fm.addFormat(f, false);
    }
}

