/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Fatal;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XModifier;
import javasoft.sqe.apiCheck.XProg;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypes;

class ReadSig {
    static final int syn_eof = -1;
    static final int syn_eol = 0;
    static final int syn_ident = 1;
    static final int syn_sep = 2;
    static final int syn_CLSS = 10;
    static final int syn_supr = 11;
    static final int syn_intf = 12;
    static final int syn_cons = 13;
    static final int syn_meth = 14;
    static final int syn_fld = 15;
    static final int syn_innr = 16;
    static final int syn_throws = 17;
    static final int syn_null = 18;
    static Keywords words;
    String fname;
    BufferedReader is;
    String line;
    StringTokenizer tokens;
    String lex;
    char chr;
    int syn;
    int errors;
    XProg prog;
    PackageSet pset;
    String version;

    ReadSig() {
    }

    int Read(API api, String f, PackageSet packs) {
        if (this.OpenStream(f) != null) {
            return 0;
        }
        if (!this.ReadLine() || !this.line.equals("#API Master signature file")) {
            this.Close();
            return 0;
        }
        this.prog = api.xprog = new XProg();
        this.pset = packs;
        api.props.Add("sigfile", f);
        long t0 = Main.GetTimer();
        if (this.version != null) {
            api.props.Add("version", this.version);
        }
        boolean r = this.Read();
        Main.PrintTimer("ReadSig " + f, t0);
        this.pset = null;
        this.prog = null;
        this.Close();
        return r ? 1 : -1;
    }

    String OpenStream(String f) {
        this.Close();
        if (f == null || (this.fname = f.trim()).length() == 0) {
            return "Missing source file name";
        }
        try {
            this.is = new BufferedReader(new FileReader(this.fname));
        }
        catch (IOException x) {
            return "Failed to open source file \"" + this.fname + "\"";
        }
        return null;
    }

    void Close() {
        this.lex = null;
        this.tokens = null;
        this.line = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        this.fname = null;
    }

    boolean Read() {
        try {
            this.errors = 0;
            if (!this.ReadLine()) {
                Fatal.Stop("Empty file");
            }
            while (this.line.startsWith("#")) {
                if (this.line.startsWith("#Version")) {
                    this.version = this.line.substring(8).trim();
                }
                this.ReadLine();
            }
            this.ReadWord();
            while (this.syn == 10) {
                this.ReadWord();
                this.ReadClass();
            }
            if (this.syn != 0) {
                this.ErrStop("Invalid symbol");
            }
            if (this.ReadLine()) {
                this.ErrStop("Invalid symbol");
            }
            return true;
        }
        catch (Error x) {
            return false;
        }
    }

    void ReadClass() throws Fatal {
        int m = this.ReadModifiers();
        this.CheckIdent();
        XClass xclass = this.prog.DefineClass(this.lex);
        this.ReadWord();
        xclass.defined = true;
        xclass.modifier = m;
        if (this.syn != 0) {
            this.ErrStop();
        }
        this.ReadLine();
        this.ReadWord();
        while (true) {
            switch (this.syn) {
                case 11: {
                    this.ReadWord();
                    if (this.syn != 18) {
                        this.CheckIdent();
                        if (xclass.extend != null) {
                            this.ErrStop();
                        }
                        xclass.extend = this.prog.DefineClass(this.lex);
                    }
                    this.ReadWord();
                    break;
                }
                case 12: {
                    this.ReadWord();
                    this.CheckIdent();
                    xclass.implement.Add(this.prog.DefineClass(this.lex));
                    this.ReadWord();
                    break;
                }
                case 13: {
                    this.ReadWord();
                    XClassConstructor xconstructor = new XClassConstructor();
                    xconstructor.modifier = this.ReadModifiers();
                    xconstructor.name = this.ReadName(xclass);
                    if (xconstructor.name == null) {
                        this.ErrStop();
                    }
                    xconstructor.args = this.ReadArgs();
                    xconstructor.xthrows = this.ReadThrows();
                    xconstructor.Link(xclass);
                    break;
                }
                case 14: {
                    this.ReadWord();
                    XClassMethod xmethod = new XClassMethod();
                    xmethod.modifier = this.ReadModifiers();
                    xmethod.type = this.ReadType();
                    xmethod.name = this.ReadName(xclass);
                    xmethod.args = this.ReadArgs();
                    xmethod.xthrows = this.ReadThrows();
                    if (xmethod.name == null) break;
                    xmethod.Link(xclass);
                    break;
                }
                case 15: {
                    this.ReadWord();
                    XClassField xfield = new XClassField();
                    xfield.modifier = this.ReadModifiers();
                    xfield.type = this.ReadType();
                    xfield.name = this.ReadName(xclass);
                    if (xfield.name == null) break;
                    xfield.Link(xclass);
                    break;
                }
                case 16: {
                    this.ReadWord();
                    int mm = this.ReadModifiers();
                    this.CheckIdent();
                    XClass xinner = this.prog.DefineClass(this.lex);
                    this.ReadWord();
                    xinner.modifier = mm;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.syn != 0) {
                this.ErrStop();
            }
            this.ReadLine();
            this.ReadWord();
        }
    }

    int ReadModifiers() {
        int m;
        int mask = 0;
        while (this.syn == 1 && (m = XModifier.Convert(this.lex)) != 0) {
            this.ReadWord();
        }
        return mask;
    }

    String ReadName(XClass xclass) throws Fatal {
        this.CheckIdent();
        int i = this.lex.lastIndexOf(".");
        if (i < 0) {
            this.ErrStop();
        }
        String s0 = this.lex.substring(0, i);
        String s1 = this.lex.substring(i + 1);
        this.ReadWord();
        return s0.equals(xclass.FullName()) ? s1 : null;
    }

    XTypes ReadArgs() throws Fatal {
        XTypes tt = new XTypes();
        if (this.syn != 2 || this.chr != '(') {
            this.ErrStop();
        }
        this.ReadWord();
        while (this.syn == 1) {
            tt.Add(this.ReadType());
            if (this.syn != 2 || this.chr != ',') break;
            this.ReadWord();
        }
        if (this.syn != 2 || this.chr != ')') {
            this.ErrStop();
        }
        this.ReadWord();
        return tt;
    }

    XTypes ReadThrows() throws Fatal {
        XTypes tt = new XTypes();
        if (this.syn == 17) {
            this.ReadWord();
            while (this.syn == 1) {
                tt.Add(this.ReadType());
                if (this.syn != 2 || this.chr != ',') break;
                this.ReadWord();
            }
        }
        return tt;
    }

    XType ReadType() throws Fatal {
        this.CheckIdent();
        XType t = this.prog.DefineType(this.lex);
        this.ReadWord();
        return t;
    }

    void CheckIdent() throws Fatal {
        if (this.syn != 1) {
            this.ErrStop("Ident expected");
        }
    }

    boolean ReadWord() {
        if (this.tokens.hasMoreElements()) {
            this.lex = (String)this.tokens.nextElement();
            this.chr = this.lex.charAt(0);
            if (this.chr == ' ') {
                return this.ReadWord();
            }
            this.syn = Character.isLetter(this.chr) || this.chr == '[' ? words.Look(this.lex) : 2;
            return true;
        }
        this.syn = 0;
        return false;
    }

    boolean ReadLine() throws Fatal {
        try {
            this.line = this.is.readLine();
            if (this.line != null) {
                this.tokens = new StringTokenizer(this.line, " ,()", true);
                return true;
            }
            return false;
        }
        catch (IOException x) {
            this.ErrStop("Read error from source file " + this.fname + "\n" + x);
            return false;
        }
    }

    void ErrStop() {
        this.ErrStop("error in .sig file");
    }

    void ErrStop(String m) {
        ++this.errors;
        System.err.println(m);
        if (this.line != null) {
            System.err.println(this.line);
        }
        throw new Error();
    }

    static {
        syn_eof = -1;
        syn_eol = 0;
        syn_ident = 1;
        syn_sep = 2;
        syn_CLSS = 10;
        syn_supr = 11;
        syn_intf = 12;
        syn_cons = 13;
        syn_meth = 14;
        syn_fld = 15;
        syn_innr = 16;
        syn_throws = 17;
        syn_null = 18;
        words = new Keywords();
    }

    static class Keywords
    extends Hashtable {
        Keywords() {
            this.Put("CLSS", 10);
            this.Put("supr", 11);
            this.Put("intf", 12);
            this.Put("cons", 13);
            this.Put("meth", 14);
            this.Put("fld", 15);
            this.Put("innr", 16);
            this.Put("throws", 17);
            this.Put("null", 18);
        }

        void Put(String word, int key) {
            super.put(word, new Integer(key));
        }

        int Look(String word) {
            Integer i = (Integer)super.get(word);
            return i == null ? 1 : i;
        }
    }
}

