/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.search.SearchException;

import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.search.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>SearchException()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Constructs a SearchException with no detail message. <p>
 * api2test: public SearchException()  <p>
 *              Constructs a SearchException with the specified detail message.  <p>
 * api2test: public SearchException(String)  <p>
 *
 * how2test: Call these APIs with/out string argument and if it successfully 
 *	     creates objects of type SearchException, then this testcase passes.
 */

public class searchException_Test extends MailTest {

    public static void main( String argv[] )
    {
        searchException_Test test = new searchException_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class SearchException: SearchException(void | String)\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

	  // BEGIN UNIT TEST 1:
	     out.println("UNIT TEST 1: SearchException()");

             SearchException se1 = new SearchException();	// API TEST

	     if( se1 != null )
	     	 out.println("UNIT TEST 1: passed.\n");
	     else {
		   out.println("UNIT TEST 1: FAILED.\n");
		   errors++;
	     }
	  // END UNIT TEST 1:
	  // BEGIN UNIT TEST 2:
	     out.println("UNIT TEST 2: SearchException(String)");

             SearchException se2 = new SearchException(subject);       // API TEST

             if( se2 != null )
                 out.println("UNIT TEST 2: passed.\n");
             else {
                   out.println("UNIT TEST 2: FAILED.\n");
                   errors++;
             }
	  // END UNIT TEST 2:

	     store.close();
             checkStatus();
        } catch ( Exception e ) {
             handlException(e);
        }
	return status;
     }
}
