/*
 * Copyright (c) 2002-2016 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Store;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>AutoCloseable</strong> API. <p>
 *
 *		Closes this store and terminates connection. <p>
 * api2test: AutoCloseable <p>
 *
 * how2test: Use try-with-resources to open the Store.
 *	     If the Store is closed (not connected) at the end of the try block
 *	     then the test passes otherwise it fails.
 */

public class autoclose_Test extends MailTest {

    public static void main( String argv[] )
    {
        autoclose_Test test = new autoclose_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Store: auto close()\n");

     // BEGIN UNIT TEST 1:
	out.println("UNIT TEST 1: auto close()");

     // Connect to host server
	Store store = null;
        try (Store istore = connect2host(protocol, host, user, password)) {
	    if (!istore.isConnected()) {
		errors++;
		out.println("UNIT TEST 1:  FAILED\n");
	    }
	    store = istore;

        } catch ( Exception e ) {
	     handlException(e);
        }

	if (errors == 0 && store != null) {
	    if (!store.isConnected()) {
		out.println("UNIT TEST 1:  passed\n");
	    } else {
		errors++;
		out.println("UNIT TEST 1:  FAILED\n");
	    }
	}

     // END UNIT TEST 1:
	checkStatus();
	return status;
     }
}
