/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getContentType()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Returns the Content-Type of the content of this message part. <p>
 * api2test: public String getContentType()  <p>
 *
 * how2test: Call this API, check that it returns an object of type string.
 *	     Make sure that this method does not return null value.
 */

public class getContentType_Test extends MailTest {

    public static String contentype = null;

    public static void main( String argv[] )
    {
        getContentType_Test test = new getContentType_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: getContentType()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if ( folder == null ) {
                  return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);
	     
 	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }

             for( int i = 1; i <= msgcount; i++ )
             {
            // Get the message
               Message msg = folder.getMessage(i);

	       if ( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	       }
	    // BEGIN UNIT TEST:
		// Get body content type of message(s)
	       out.println("UNIT TEST "+ i +":  getContentType()");

	       contentype = msg.getContentType();		// API TEST
	       out.println("getContentType() :=> "+ contentype);

	       if (( contentype != null ) && ( contentype instanceof String ))
                     out.println("UNIT TEST "+ i +":  passed\n");
	       else {
		     out.println("UNIT TEST "+ i +":  FAILED\n");
		     errors++;
	       }
	    // END UNIT TEST:
	    }
	    folder.close(false);
	    store.close();
	    checkStatus();

        } catch ( Exception e ) {
	    handlException(e);
        }
	return status;
     }
}
