/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.TestClasses;

import	javax.activation.*;

/** Test uitlity used by DataHandler class.
 */

public class TestDCHFactory implements DataContentHandlerFactory
{
    private String mimeType = null;

    public TestDCHFactory() {
    }

    public TestDCHFactory(String mimeType)
    {
	this.mimeType = mimeType;
    }
    // We allow the factory to make a distinctive TestDCH based upon an optional
    // mimeType constructor argument, to allow tests to prove that 
    // DataHandler.setDataContentHandlerFactory overrides the affect setCommandMap.

    public DataContentHandler createDataContentHandler(String mimeType)
    {
	if (this.mimeType != null)
	    return new TestDCH(this.mimeType);
	else
	    return new TestDCH(mimeType);
    }
}
