/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.URLDataSource;

import  java.net.*;
import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * Create an instance of URLDataSource, use it call getURL() api, if it
 * returns expected URL for this DataSource, then this testcase passes,
 * otherwise it fails. <p>
 */

public class getURL_Test extends MultiTest
{
private static final String httpURLSpec = "http://www.sun.com/index.html";
private static final String badURLSpec  = "http://www.nonexistentdomain.com";

public static void main(String argv[])
{
	getURL_Test lTest = new getURL_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status getURL_Test() throws IOException, MalformedURLException
{
	URL goodURL  = new URL(httpURLSpec);
	URLDataSource gds = new URLDataSource(goodURL);

	if (!goodURL.equals(gds.getURL()))	// API TEST
		return Status.failed("Failed: getURL didn't match initializer");

	URL badURL = new URL(badURLSpec);
	URLDataSource bds = new URLDataSource(badURL);

	if (!badURL.equals(bds.getURL()))	// API TEST
		return Status.failed("Failed: bad url, getURL didn't match initializer");

	return Status.passed("getURL() test succeeded");
}

}
