/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.URLDataSource;

import java.net.*;
import java.io.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * Create instances of URLDataSource, using the constructors of this class.
 * If it returns objects of type URLDataSource, then this testcase passes,
 * otherwise it fails. <p>
 */

public class URLDataSource_Test extends MultiTest
{
private static final String fileURLSpec = "file:test.txt";
private static final String httpURLSpec = "http://www.sun.com/index.html";
private static final String badURLSpec  = "http://www.nonexistentdomain.com";

public static void main(String argv[])
{
	URLDataSource_Test lTest = new URLDataSource_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status URLDataSourceTest1() throws IOException, MalformedURLException
{
	URL goodURL  = new URL(httpURLSpec);
	URLDataSource gds = new URLDataSource(goodURL); 	// API TEST

	if (!goodURL.equals(gds.getURL()))
		return Status.failed("URLDataSourceTest failed: getURL didn't match initializer");

	String urlName = goodURL.getFile();
	String dsName  = gds.getName();

	if (urlName == null) {
	    if (dsName != null)
		return Status.failed("URLDataSourceTest failed: getName() != URL.getFile()");
	} else if (!urlName.equals(dsName)){
	           return Status.failed("URLDataSourceTest failed: getName() != URL.getFile()");
	}
	return Status.passed("URLDataSource(URL http) test succeeded");
}

public Status URLDataSourceTest2() throws IOException, MalformedURLException
{
	URL goodURL = new URL(fileURLSpec);
	URLDataSource gds = new URLDataSource(goodURL); 	// API TEST

	if( gds == null)
	    return Status.failed("Failed to create URLDataSource object");

	return Status.passed("URLDataSource(URL goodURL) test succeeded");
}

public Status URLDataSourceTest3() throws IOException, MalformedURLException
{
	URL badURL = new URL(badURLSpec);
	URLDataSource bds = new URLDataSource(badURL);		// API TEST

	if (!badURL.equals(bds.getURL()))
	    return Status.failed("URLDataSourceTest for bad url failed: getURL didn't match initializer");

	String urlName = badURL.getFile();
	String dsName = bds.getName();

	if (urlName == null) {
	    if (dsName != null)
		return Status.failed("URLDataSourceTest failed: getName() != URL.getFile()");
	} else if (!urlName.equals(dsName)){
	           return Status.failed("URLDataSourceTest failed: getName() != URL.getFile()");
	}
	return Status.passed("URLDataSource(URL badURL) test succeeded");
}

}
