/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call setParameter() method
 * with given string parameters, then call getParameter(), if set/get
 * values are equal, then this test passes otherwise it fails. <p>
 */

public class setParameter_Test extends MultiTest
{
public static void main(String argv[])
{
	setParameter_Test lTest = new setParameter_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status setParameterTest()
{
	try {	// create MimeType object
		MimeType objmt =  new MimeType();

		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using a constructor");

		objmt.setParameter("charset", "us-ascii");	// API TEST

		if( !(objmt.getParameter("charset")).equals("us-ascii") )
		    return Status.failed("Failed: setParameter(charset, us-ascii)");

		objmt.setParameter("abc", "xyz");		// API TEST

		if( !(objmt.getParameter("abc")).equals("xyz") )
		    return Status.failed("Failed: setParameter(abc, xyz)");

		objmt.setParameter("foo", "");		// API TEST

                if( objmt.getParameter("foo") != "" )
                    return Status.failed("Failed: setParameter(foo, emptyString)");

	} catch(Exception ex) {
		ex.printStackTrace();
		return Status.failed("setParameter(string,string) threw " + ex.toString());
	}

	return Status.passed("setParameter(String,String) test succeeded");
}

}
