/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call removeParameter() method with
 * given string name, then call getParameter(), if this method returns null
 * (since it has been deleted), then this test passes otherwise it fails. <p>
 */

public class removeParameter_Test extends MultiTest
{

public static void main(String argv[])
{
	removeParameter_Test lTest = new removeParameter_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status removeParameterTest()
{
	try {	// create MimeType object
		MimeType objmt =  new MimeType();

		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using a constructor");

		objmt.setParameter("charset", "us-ascii");
		objmt.removeParameter("charset");		// API TEST

		if( objmt.getParameter("charset") != null )
		    return Status.failed("Failed: removeParameter(charset)");

		objmt.setParameter("abc", "xyz");
		objmt.removeParameter("abc");

		if( objmt.getParameter("abc") != null )	// API TEST
		    return Status.failed("Failed: removeParameter(abc)");

		objmt.setParameter("foo", "");
		objmt.removeParameter("foo");		// API TEST

                if( objmt.getParameter("foo") != null )     // API TEST
                    return Status.failed("Failed: removeParameter(foo)");

	} catch(Exception ex) {
		ex.printStackTrace();
		return Status.failed("removeParameter(string) threw " + ex.toString());
	}

	return Status.passed("removeParameter(String) test succeeded");
}

}
