/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.DataHandler;

import	java.io.*;
import	java.awt.datatransfer.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create instances of DataHandler, then use invoke  setMapCommand() api, with
 * various CommandMap object parameters. If  this operation is successfull
 * then this testcase passes, otherwise it fails. <p>
 */

public class setMapCommand_Test extends MultiTest
{
private static final String	kFileName = "foo.txt";
private String message = null;

public static void main(String argv[])
{
	setMapCommand_Test lTest = new setMapCommand_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status setCommandMapTest()
{
	DataHandler dh1 = new DataHandler(new TestCommandObject(), "foo/plain");

	// Test setting an alternative command map and then clearing it.  We won't actually
	// test the set state here, that's for another test.

	dh1.setCommandMap(new TestCommandMap(null));		// API TEST
	dh1.setCommandMap(null);				// API TEST

	FileDataSource fds = new FileDataSource(kFileName);
	DataHandler dh2 = new DataHandler(fds);
	TestCommandMap tcm = new TestCommandMap(fds.getContentType());

	dh2.setCommandMap(tcm);		// API TEST

        String mimeType = fds.getContentType();
        DataFlavor refdf = new DataFlavor(mimeType, "who cares?");
        dh2.setCommandMap(new TestCommandMap(mimeType));

        if (!checkFlavors(dh2, mimeType))
            return Status.failed("DataHandler(DataSource).getTransferDataFlavors() : " + message);

        DataHandler dh3 = new DataHandler(new TestCommandObject(), "foo/goo");
        dh3.setCommandMap(new TestCommandMap("foo/goo"));	// API TEST

        if (!checkFlavors(dh3, "foo/goo"))
	     return Status.failed("DataHandler. using mapped DataContentHandler "  + message);

        return Status.passed("setCommandMap() test succeeded");
}
// The only way to determine if a dh is using the appropriate DataContentHandler
// is to see if  getTransferDataFlavors returns what we expect from a TestDCH
// the assumption is that some other 

private boolean checkFlavors(DataHandler dh, String mimeType)
{
    DataFlavor dfs[] = dh.getTransferDataFlavors();
    if (dfs == null) {
	message = "getTransferDataFlavors() returned null";
	return false;
    }
    if (dfs.length != 1){
	message = "getTransferDataFlavors() has wrong number of elements";
	return false;
    }
    DataFlavor df = dfs[0];
    if (!df.isMimeTypeEqual(mimeType)){
	message = "getTransferDataFlavors() contains wrong flavor: " + df.getMimeType();
	return false;
    }
    return true;
}

}
